<?php
// ¡IMPORTANTE! No debe haber NADA de HTML antes o después de estas líneas.
include 'phpqrcode/qrlib.php';
function bigint_to_base36(string $num): string
{
    $chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    $num = ltrim($num, "+");
    if ($num === "0") return "0";
    $result = "";

    while (bccomp($num, "0") > 0) {
        $rem = bcmod($num, "36");
        $num = bcdiv($num, "36", 0);
        $result = $chars[(int)$rem] . $result;
    }

    return strtoupper($result);
}
function deterministic_fill(string $seedStr, int $length): string
{
    if ($length <= 0) return "";
    $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    $seed = 0;
    for ($i = 0; $i < strlen($seedStr); $i++) {
        $seed = ($seed * 131 + ord($seedStr[$i])) & 0xFFFFFFFF;
    }

    $out = "";
    $s = $seed;
    for ($i = 0; $i < $length; $i++) {
        $s = ($s * 1664525 + 1013904223) & 0xFFFFFFFF;
        $idx = $s % strlen($chars);
        $out .= $chars[$idx];
    }
    return $out;
}
function codificar(string $numero, int $clave = 7): string
{
    if (!ctype_digit($numero)) {
        throw new Exception("Solo se permiten números positivos");
    }

    // 1) Multiplicar por la clave (como BigInt)
    $prod = bcmul($numero, (string)$clave);

    // 2) Convertir a base36
    $payload = bigint_to_base36($prod);
    $L = strlen($payload);
    if ($L > 14) {
        throw new Exception("Número demasiado grande para caber en 15 caracteres (L=$L).");
    }

    // 3) Meta (longitud en base36, un solo carácter)
    $chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    $metaChar = $chars[$L];

    // 4) Generar relleno determinístico
    $fillLen = 15 - 1 - $L;
    $fill = deterministic_fill($payload, $fillLen);

    // 5) Unir todo
    $code = strtoupper($metaChar . $fill . $payload);
    if (strlen($code) !== 15) {
        throw new Exception("Error interno: el código no tiene 15 caracteres.");
    }

    return $code;
}

$hash = codificar("12912686");

$url_destino = "http://172.17.1.38/qr/trabajador_" . $hash;
//$data_to_encode = $url_destino . '?id_cedula=' . urlencode($cedula_valor);

// Esta línea le dice a PHP que va a imprimir una imagen.
header('Content-Type: image/png');

// Esta llamada imprime la imagen BINARIA DIRECTAMENTE al navegador.
// El segundo parámetro está nulo (o no se pasa).
QRcode::png($url_destino, false, 'L', 8, 2);
