<?php
include 'BD.php'; // Conexión PostgreSQL

// --- FUNCIONES ---
function base36_to_bigint(string $str): string
{
    $chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    $str = strtoupper($str);
    $num = "0";
    for ($i = 0; $i < strlen($str); $i++) {
        $val = strpos($chars, $str[$i]);
        if ($val === false) {
            throw new Exception("Carácter inválido en base36: " . $str[$i]);
        }
        $num = bcmul($num, "36");
        $num = bcadd($num, (string)$val);
    }
    return $num;
}

function decodificar(string $code, int $clave = 7): string
{
    $chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    $code = strtoupper(trim($code));

    if (strlen($code) !== 15) {
        throw new Exception("El código debe tener exactamente 15 caracteres.");
    }

    // 1️⃣ Primer carácter = longitud del payload
    $metaChar = $code[0];
    $L = strpos($chars, $metaChar);
    if ($L === false) {
        throw new Exception("Carácter meta inválido.");
    }

    // 2️⃣ Extraer el payload (los últimos L caracteres)
    $payload = substr($code, -$L);

    // 3️⃣ Convertir de base36 a número
    $prod = base36_to_bigint($payload);

    // 4️⃣ Dividir entre la clave para obtener el número original
    if (bcmod($prod, (string)$clave) !== "0") {
        throw new Exception("Código o clave incorrecta: no divisible entre clave.");
    }

    $original = bcdiv($prod, (string)$clave, 0);
    return $original;
}


// --- VARIABLES INICIALES ---
$nombre_completo = "No proporcionado";
$apellido_completo = "";
$fecha_ingreso = "N/A";
$mensaje_estado = "Esperando cédula...";
$cargo = "N/A";
$dependencia = "N/A";

// --- OBTENER Y DECODIFICAR HASH ---
$cedula = null;
if (isset($_GET['hash'])) {
    $hash = $_GET['hash'];
    try {
        $cedula = decodificar($hash, 7);
    } catch (Exception $e) {
        $mensaje_estado = "Error al decodificar: " . $e->getMessage();
    }
} else {
    $mensaje_estado = "No se recibió ningún parámetro 'hash'.";
}

// --- SI SE DECODIFICÓ CORRECTAMENTE ---
if ($cedula && is_numeric($cedula)) {
    $sql = "
        SELECT personal.id_personal,
               personal.primer_apellido as apellido1,
               personal.segundo_apellido as apellido2,
               personal.primer_nombre as nombre1,
               personal.segundo_nombre as nombre2,
               personal.nacionalidad,
               personal.cedula as cedula,
               trabajador.fecha_ingreso,
               trabajador.codigo_nomina as cod_nom,
               cargo.descripcion_cargo,
               dependencia.nombre as nombre_dep
        FROM trabajador
        INNER JOIN personal ON personal.id_personal = trabajador.id_personal
        INNER JOIN cargo ON trabajador.id_cargo = cargo.id_cargo
        INNER JOIN dependencia ON dependencia.id_dependencia = trabajador.id_dependencia
        WHERE personal.cedula = '$cedula' AND estatus = 'A'
    ";

    $resultado = pg_query($conexion, $sql);

    if (!$resultado) {
        $mensaje_estado = "🔴 ERROR SQL o de Conexión: " . pg_last_error($conexion);
    } elseif (pg_num_rows($resultado) > 0) {
        $persona = pg_fetch_assoc($resultado);
        $nombre_completo = trim(($persona['nombre1'] ?? '') . ' ' . ($persona['nombre2'] ?? ''));
        $apellido_completo = trim(($persona['apellido1'] ?? '') . ' ' . ($persona['apellido2'] ?? ''));
        $cargo = $persona['descripcion_cargo'] ?? 'N/A';
        $dependencia = $persona['nombre_dep'] ?? 'N/A';

        if (!empty($persona['fecha_ingreso'])) {
            $fecha_bd = date_create($persona['fecha_ingreso']);
            $f_ingreso = date_format($fecha_bd, 'd/m/Y');
        } else {
            $f_ingreso = 'N/A';
        }
    } else {
        $mensaje_estado = "⚠️ Cédula '$cedula' no encontrada en la tabla 'personal'.";
    }
}

if (isset($conexion)) {
    pg_close($conexion);
}
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Información de la Persona</title>
</head>
<style>
    body {
        background-color: #f8f9fa;
        /* Color inicial (blanco pálido) */
        display: flex;
        flex-direction: column;
        /* Permite apilar elementos verticalmente */
        justify-content: center;
        align-items: center;
        min-height: 100vh;
        margin: 0;
        padding: 30px;
        overflow: hidden;
        /* Evita scroll si la animación o el carnet se desbordan */

        /* --- Animación del Fondo --- */
        animation: changeBackgroundColor 30s infinite alternate;
    }

    /* Marca de agua de fondo */
    body::before {
        content: "";
        position: fixed;
        /* permanece al hacer scroll */
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;

        /* Ruta de tu imagen */
        background-image: url("logo_min.trabajo.png");

        /* 🔸 Se repite la imagen en mosaico */
        background-repeat: repeat;

        /* 🔸 Ajustes opcionales */
        background-position: center center;
        background-size: 15%;
        /* cambia el tamaño del logo */
        opacity: 0.08;
        /* transparencia para no molestar el texto */

        z-index: -1;
        /* se coloca detrás del contenido */
        pointer-events: none;
        /* no interfiere con clics */
    }

    @keyframes changeBackgroundColor {
        0% {
            background-color: #f8f9fa;
            /* Blanco */
        }

        50% {
            background-color: #e0f2f7;
            /* Un azul claro para la transición */
        }

        100% {
            background-color: #f8f9fa;
            /* Vuelve a blanco al final del ciclo */
        }
    }

    /* Estilo para el frontal del carnet (REDUCIDO A LA MITAD) */
    #carnetFrontal {
        font-family: 'Georama', sans-serif;
        background-color: white;
        background-size: 100% 100%;
        background-repeat: no-repeat;
        background-position: center center;
        border-radius: 20px;
        position: relative;
        box-shadow: none;
        display: flex;
        flex-direction: column;
        align-items: center;

        /* 🔹 Medidas base */
        width: 430px;
        height: 540px;

        /* 🔹 Centrar si es necesario */
        margin: 0 auto;
    }

    /* 📱 Responsivo: pantallas medianas (tablets) */
    @media (max-width: 992px) {
        #carnetFrontal {
            width: 70vw;
            /* 70% del ancho de la ventana */
            height: calc(75vw * 1.26);
            /* Mantiene la proporción (540/430 ≈ 1.26) */
        }
    }

    /* 📱 Responsivo: pantallas pequeñas (celulares) */
    @media (max-width: 600px) {
        img {
            width: 350px !important;
        }

        #carnetFrontal {
            width: 90vw;
            /* Ocupa casi todo el ancho */
            height: calc(95vw * 1.26);
            border-radius: 12px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
    }

    /* 📱 Muy pequeñas (teléfonos viejos, pantallas pequeñas) */
    @media (max-width: 400px) {
        img {
            width: 330px !important;
        }

        #carnetFrontal {
            width: 95vw;
            height: calc(110vw * 1.26);
            border-radius: 8px;
        }
    }


    /* Estilo para el reverso del carnet (REDUCIDO A LA MITAD) */
    .carnet-trasero {
        background-image: url("http://carnetsmp.ciip.com.ve/carnets imagenes/CARNET-02.jpg");
        background-size: 100% 100%;
        background-repeat: no-repeat;
        background-position: center center;
        width: 317px;
        /* 634px / 2 = 317px */
        height: 502px;
        /* 1004px / 2 = 502px */
        position: relative;
        box-shadow: none;
        display: flex;
        flex-direction: column;
        justify-content: flex-end;
        align-items: flex-end;
        padding: 10px;
        /* 20px / 2 = 10px */
        padding-bottom: 2.5px;
        /* 5px / 2 = 2.5px */
        box-sizing: border-box;
    }

    /* Contenedor del código de barras (REDUCIDO A LA MITAD) */
    .barcode-container {
        width: 100px;
        /* 200px / 2 = 100px */
        height: 25px;
        /* 50px / 2 = 25px */
        display: flex;
        justify-content: right;
        align-items: center;
        overflow: hidden;
        vertical-align: middle;
        margin-bottom: 125px;
        /* 250px / 2 = 125px */
        margin-right: 0.5px;
        /* 1px / 2 = 0.5px */
    }

    /* Estilos específicos para la imagen del QR (REDUCIDO A LA MITAD) */
    .qr-code-img {
        height: 60px;
        /* 120px / 2 = 60px */
        width: 60px;
        /* 120px / 2 = 60px */
        display: block;
        margin-right: 37px;
        /* 74px / 2 = 37px */
        margin-bottom: 145.5px;
        /* 291px / 2 = 145.5px */
    }

    /* Cuerpo principal del carnet (REDUCIDO A LA MITAD) */
    .carnet-body {

        position: relative;
        z-index: 1;
        width: 100%;
        height: 100%;
        box-sizing: border-box;
        padding: 5%;
        /* El porcentaje se mantiene igual, aunque el efecto es sobre el nuevo tamaño */
        padding-top: 10px;
        /* 334px / 2 = 167px */
    }

    /* Foto de perfil (REDUCIDO A LA MITAD) */
    .profile-picture {
        width: 122px;
        /* 241px / 2 = 120.5px */
        aspect-ratio: 1/1;
        object-fit: fill;
        object-position: top;
        margin: 0 auto 10px auto;
        /* 20px / 2 = 10px */
        display: block;
        border: none;
        border-radius: 8px;
        /* 16px / 2 = 8px */
    }

    /* Valores de información (Tamaño de fuente ajustado) */
    .info-value {
        color: black;
        font-weight: bold;
        display: block;
        line-height: 1.3;
        /* Se mantiene igual */
        text-shadow: 0 0 1px rgba(255, 255, 255, 0.5);
    }

    /* Nombre (REDUCIDO A LA MITAD en fuente) */
    .name-value {
        margin-top: 6px;
        margin-bottom: 6px;
        font-size: 22.5px;
        /* 45px / 2 = 22.5px */
        font-weight: 700;
        line-height: 1;
        color: #323364;
    }

    /* ID (REDUCIDO A LA MITAD en fuente y márgenes) */
    .id-value {
        font-size: 14px;
        /* 28px / 2 = 14px */
        font-weight: 600;
        margin-top: 10px;
        /* 20px / 2 = 10px */
        margin-bottom: 2.5px;
        /* 5px / 2 = 2.5px */
        color: #565756;
    }

    /* Departamento (El porcentaje se mantiene, pero el valor absoluto se reduce) */
    .department-value {
        font-family: 'Georama', sans-serif;
        position: absolute;
        color: white;
        font-size: 50%;
        /* Se reduce el tamaño relativo para que encaje mejor si el 100% original era muy grande */
        font-weight: bold;
        bottom: 10px;
        /* 20px / 2 = 10px */
        width: 100%;
        left: 0%;
        margin: 0 auto;
    }

    /* Posición (REDUCIDO A LA MITAD en fuente y margen) */
    .position-value {
        font-size: 9px;
        /* 18px / 2 = 9px */
        font-weight: 800;
        margin-top: 10px;
        /* 20px / 2 = 10px */
    }

    /* Área de firma (Márgenes y padding ajustados) */
    .signature-area {
        margin-top: 15px;
        /* 30px / 2 = 15px */
        text-align: center;
        font-style: italic;
        border-top: 1px dashed #ced4da;
        /* Se mantiene 1px, pero podría reducirse si se desea */
        padding-top: 5px;
        /* 10px / 2 = 5px */
        font-size: 0.8em;
        /* Se mantiene o se ajusta a 0.4em para la mitad, pero 0.8em es mejor para legibilidad */
    }

    /* Botón de descarga (Márgenes y padding ajustados) */
    .btn-descargar {
        margin-top: 15px;
        /* 30px / 2 = 15px */
        padding: 5px 10px;
        /* 10px 20px / 2 */
        background-color: #007bff;
        color: white;
        border: none;
        border-radius: 2.5px;
        /* 5px / 2 = 2.5px */
        cursor: pointer;
        font-size: 0.8em;
        /* Se ajusta para que sea más pequeño */
        transition: background-color 0.3s ease;
    }

    .btn-descargar:hover {
        background-color: #0056b3;
    }
</style>

<body>

    <div style="display:flex;">
        <div class="carnet-container" id="carnetFrontal">
            <img src="logo_min.trabajo.png" alt="" style="width: 385px;margin: 15px; ">
            <h3 class="name-value" style="margin-top: 20px; margin-bottom: 20px;"> DATOS DEL TRABAJADOR</h3>
            <div class="carnet-body">
                <!-- <img src="logo2.png" alt="Foto por defecto" class="profile-picture"> -->
                <div class="info-row">
                    Nombre(s) y Apellido(s):<br>
                    <span class="info-value name-value" style="font-size: 17.5px;"><?php echo htmlspecialchars($nombre_completo) . " " . htmlspecialchars($apellido_completo); ?></span><br>
                    Cédula de Identidad:<br>
                    <span class="info-value name-value" style="font-size: 17.5px;margin-top: 5px;">V-<?php echo htmlspecialchars($cedula); ?></span><br>

                    Cargo:<br>
                    <span class="info-value name-value" style="font-size: 17.5px;"><?php echo htmlspecialchars($cargo); ?></span><br>


                    Ubicación Administrativa:<br>
                    <span class="info-value name-value" style="font-size: 17.5px;"><?php echo htmlspecialchars($dependencia); ?></span><br>


                    Fecha de Ingreso <br>
                    <span class="info-value name-value" style="font-size: 17.5px;"><?php echo htmlspecialchars($f_ingreso); ?></span><br>
                </div>


            </div>
        </div>
    </div>
</body>

</html>